/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.async;

import com.ftdi.FTD2XXException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import sidblaster.Command;
import sidblaster.CommandEnum;
import sidblaster.async.CommandReceiver;

public class ThreadCommandReceiver
extends CommandReceiver
implements Runnable {
    private BlockingQueue<Command> queue = new ArrayBlockingQueue<Command>(256);
    private boolean flush;
    private volatile boolean devicesAvailable;

    @Override
    public void run() {
        try {
            int deviceNum;
            for (deviceNum = 0; deviceNum < this.deviceCount(); ++deviceNum) {
                this.executeCommand(new Command(deviceNum, CommandEnum.OpenDevice));
            }
            this.devicesAvailable = true;
            while (!this.abortSIDWriteThread) {
                while (this.commandsPending()) {
                    this.executeCommand(this.tryGetCommand());
                }
            }
            for (deviceNum = 0; deviceNum < this.deviceCount(); ++deviceNum) {
                this.executeCommand(new Command(deviceNum, CommandEnum.CloseDevice));
            }
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean commandsPending() {
        return !this.queueIsEmpty() || this.flush;
    }

    public boolean queueIsEmpty() {
        return this.queue.isEmpty();
    }

    public void flush() {
        this.flush = true;
    }

    public void tryPutCommand(Command params) throws InterruptedException {
        this.queue.put(params);
    }

    private Command tryGetCommand() {
        if (this.flush) {
            this.flush = false;
            this.queue.clear();
            return new Command(0, CommandEnum.Flush);
        }
        return (Command)this.queue.poll();
    }

    public boolean isDevicesAvailable() {
        return this.devicesAvailable;
    }
}

